<?php

/*

Kontackt License Agreement (DMCA License)

Copyright (c) 2015, Alex Dobrovolscki (dobriisasa@gmail.com)
All rights reserved.

* Redistributions of source code is strictly forbidden.

* By using Kontackt you may have your own purchase copy, if you are not own a license, you can buy one from https://codecanyon.net/user/dobrovolscki/portfolio.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/


// engine file
require_once('../../inc/_core.php');


try {
	 
	$core = new _SOCIALPLUS;
        $glb  = $core->im_global();



// define variables and set to empty values
$nameErr = $lnameErr = $emailErr = $passErr = $captchaErr = "";
$fname = $lname = $email = $pass = $username = $captcha = "";
$errors = array();

if ($_SERVER["REQUEST_METHOD"] == "POST")
	{

	$fname = isset($_POST['first_name']) ? $core->test_input($_POST['first_name']) : '';
	$sname = isset($_POST['surname']) ? $core->test_input($_POST['surname']) : '';
    $fullname = $fname .' '.$sname;
	$day = isset($_POST['day']) ? $core->test_input($_POST['day']) : '';
	$month = isset($_POST['month']) ? $core->test_input($_POST['month']) : '';
	$year = isset($_POST['year']) ? $core->test_input($_POST['year']) : '';
	$gender = isset($_POST['fr_gender']) ? $core->test_input($_POST['fr_gender']) : '';
	$country = isset($_POST['country']) ? $core->test_input($_POST['country']) : '';
	$city = isset($_POST['city']) ? $core->test_input($_POST['city']) : '';
	$email = isset($_POST['reg_email']) ? $core->test_input($_POST['reg_email']) : '';
	$pass = isset($_POST['reg_pass']) ? $core->test_input($_POST['reg_pass']) : '';
    $birthday = $year.'-'.$month.'-'.$day;//$day.'-'.$month.'-'.$year;

	if($gender == '1') $gender = 'male'; else $gender = 'female';

	if(empty($fname))
	array_push($errors,$core->lang['sg_empty_name']);
	else if (!preg_match("/^[a-zA-Z]*$/", $fname))
	array_push($errors,$core->lang['sg_invalid_name']);

	if(empty($sname))
	array_push($errors,$core->lang['sg_empty_surname']);
	else if (!preg_match("/^[a-zA-Z]*$/", $sname))
	array_push($errors,$core->lang['sg_invalid_surname']);

	if($fname == $sname)
	array_push($errors,$core->lang['sg_dupl_names']);

	if(empty($email))
	array_push($errors,$core->lang['sg_empty_email']);
	else if (!filter_var($email, FILTER_VALIDATE_EMAIL))
	array_push($errors,$core->lang['sg_invalid_email']);

	if(empty($pass))
	array_push($errors,$core->lang['sg_empty_password']);
	else if (strlen($pass) < 6)
	array_push($errors,$core->lang['sg_min_pass_length']);


		// get country id 
		$country_city_query = $core->db->query("select s.name as sname, c.name as cname, c.id as country_id, s.id as state_id from ".tbl_countries." c 
												left join ".tbl_states." s ON s.id = '{$city}'												
												where c.id = '{$country}' group by c.id limit 1");
		$country_city_id = $country_city_query->fetch_array(MYSQLI_ASSOC);
		$country_id = isset($country_city_id['country_id']) ? $country_city_id['country_id'] : 0;
		$state_id = isset($country_city_id['state_id']) ? $country_city_id['state_id'] : 0;
		$country_name = isset($country_city_id['cname']) ? $core->test_input($country_city_id['cname']) : '';
		$city_name = isset($country_city_id['sname']) ? $core->test_input($country_city_id['sname']) : '';
		
	// search country in database and return ID
	$countryID = $core->findCountryInDb($country_name);
	$cityID = $core->findCityInCountry($city_name,$country_id);
	

	if(!$countryID) {array_push($errors,'Ivalid country, please choose one from dropdown list');} // invalid country
	if(!$cityID) {array_push($errors,'Ivalid city, please choose one from dropdown list');} // invalid city	


	// check if email addy is already in use
	$a = count($core->query_select("select id from " . tbl_users . " where email='{$email}' limit 1"));
	if ($a != 0)
		{
		array_push($errors,$core->lang['sg_email_in_use']);

		}
	
	if (sizeof($errors) > 0)
		{
		// call header
		$core->build_header();
		$glb->errorMessage($errors);

              } else {
		$secret = $core->mksecret();
		$new_pass = md5($secret . $pass . $secret);
		$editsecret = $core->mksecret();
		$search = $core->test_input($fullname.' '.$core->getUserAge($birthday).' '.$city_name.' '.$country_name);
		$now = time();	
		
		// check for admin
		$c_admin = count($core->query_select("select id from ".tbl_users));
		
		$user_class = !$c_admin ? 'UC_SYSOP' : 'UC_USER';
		
		$sql = "insert into " . tbl_users . " SET  `name`='{$fname}',`surname` = '{$sname}', `fullname` = '{$fullname}',
					 `birthday` = '{$birthday}', `added` = '{$now}', `gender`='{$gender}', `country` = '{$country_id}', `city`='{$state_id}', `search`='{$search}',
					 `email`='{$email}', `password` = '{$new_pass}', `real_pass` = '{$pass}', `class`='{$user_class}', `secret`='{$secret}',`editsecret`='{$editsecret}',`status`='".$core->settings['USER_REG_STATUS']."'";
		$insert = $core->query_insert($sql);
		if ($insert){
			// create slideshow for respective user
			$core->query_insert("insert into ".tbl_slideshow." set `userid`='{$insert}',`added`='{$now}'");
		
 if($core->settings['USER_REG_STATUS'] == 'confirmed'){
 $core->signincookie($insert, $new_pass);
 header("location: ".$core->settings['HOST']."?welcome=1");
 } else {

 echo 'An confirmation has been sent to your email';
 }

}
		}
	} else $glb->errorMessage(['0' => 'Oooops. An error ocurred, please retry.']);



        // call footer
	$core->get_footer();

} catch (Exception $e) {
	print $e->getMessage();
}